import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import course1 from '/images/course-1.jpg'
import course2 from '/images/course-2.jpg'
import course3 from '/images/course-3.jpg'
import course4 from '/images/course-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: course1,
      title: 'Курс 1'
    },
    {
      id: 2,
      src: course2,
      title: 'Курс 2'
    },
    {
      id: 3,
      src: course3,
      title: 'Курс 3'
    },
    {
      id: 4,
      src: course4,
      title: 'Курс 4'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-brutal">
      <div className="slider-wrapper-brutal">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-brutal ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-brutal" />
            <div className="slide-overlay-brutal"></div>
            <div className="slide-content-brutal">
              <h3 className="slide-title-brutal">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-brutal prev-brutal" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-brutal" size={28} />
      </button>
      <button className="slider-btn-brutal next-brutal" onClick={goToNext}>
        <ChevronRight className="slider-icon-brutal" size={28} />
      </button>
      <div className="slider-dots-brutal">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-brutal ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider

